﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using ComiDll;
using System.Runtime.InteropServices;

namespace ADCcon
{
    public partial class Form1 : Form
    {
        IntPtr g_hDevice = IntPtr.Zero;
        public bool g_bScanStart = false;
        public const int BigBufSize = 10240;
        public const int TempBufSize = 1024;
        public bool single1 = true;
        public const int CH_NUM = 6; // AD 스캔을 원하는 채널 개수

        public enum CHLIST
        {
            CH0, CH1, CH2, CH3, CH4, CH5
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            g_hDevice = CDDLL.COMI_LoadDevice((int)CDDLL.TCmDeviceID.COMI_SD101, 0);

            if (g_hDevice == IntPtr.Zero) MessageBox.Show("Device SD101 로드 실패");
        }

        private void BtnStop_Click(object sender, EventArgs e)
        {
            BtnStart.Enabled = true;
            timer1.Enabled = false;

            CDDLL.COMI_US_Stop(g_hDevice, 1);
            g_bScanStart = false;
        }

        private void CmbCh_SelectedIndexChanged(object sender, EventArgs e)
        {
            //axComiGraph1.TargetChannel = 0;
            //axComiGraph1.ChannelTitle = CmbCh.Text;
            //axComiGraph1.RefreshAll();
        }

        private void EdtFreq_TextChanged(object sender, EventArgs e)
        {
            //if (EdtFreq.Text.Length==0)
            //{
            //    EdtFreq.Text = convert.100;
            //}
            //else if (EdtFreq.Text > 1000)
            //{
            //    EdtFreq.Text = "1000";
            //}
            //else if (EdtFreq.Text < 0)
            //{
            //    EdtFreq.Text = "100";
            //}
        }

        private void BtnStart_Click(object sender, EventArgs e)
        {
            BtnStart.Enabled = false;
            timer1.Interval = 100;
            timer1.Enabled = true;

            int i;
            int ScanFreq = Convert.ToInt32(this.EdtFreq.Text);
            int nResult;

            int []ChannelList = new int [CH_NUM];

            for (i = 0; i< CH_NUM; i++)
            {
                ChannelList[i] = i;
            }

            try
            {
                nResult = CDDLL.COMI_US_Start(g_hDevice, CH_NUM, ChannelList, ScanFreq, BigBufSize, (int)CDDLL.TCdAiScanTrs.cmTRS_SINGLE);

                if (nResult > 0) // nResult 는 적용된 scan freq 를 반환
                {
                    g_bScanStart = true;
                }
                else
                {
                    MessageBox.Show("Aiscan 이 정상적으로 수행되지 않음");
                }
            }
            catch
            {
                MessageBox.Show("Aiscanstart함수오류 발생");
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (!g_bScanStart) return;

            IntPtr repsPtr;

            CDDLL.ScanData scandata = new CDDLL.ScanData();
            scandata.fData = new double[TempBufSize];

            repsPtr = Marshal.AllocHGlobal(Marshal.SizeOf(typeof(CDDLL.ScanData)));
            Marshal.StructureToPtr(scandata, repsPtr, false);

            int nStartCount = CDDLL.COMI_US_CurCount(g_hDevice);

            int ch = CmbCh.SelectedIndex;
            int nRetrvCount = CDDLL.COMI_US_RetrvChannel(g_hDevice, ch, 0, TempBufSize, repsPtr, (int)CDDLL.TCdVarType.VT_DOUBLE);

            if (nRetrvCount > 0)
            {
                CDDLL.ScanData reps = (CDDLL.ScanData)Marshal.PtrToStructure(repsPtr, typeof(CDDLL.ScanData));
                // reps.fData 가 A/D 된 데이터 버퍼입니다

                double fMean = 0.0;
                double fSum = 0.0;
                for (int i = 0; i < TempBufSize; i++)
                {
                    fSum += reps.fData[i];
                }
                fMean = fSum / TempBufSize;  // 평균값임, 실제로는 노이즈 성분을 제외하기 위해 중간 값으로 계산하는 것이 좋습니다.

                listBox1.Items.Add(fMean.ToString());
                listBox1.SelectedIndex = listBox1.Items.Count - 1;
            }

            Marshal.FreeHGlobal(repsPtr);
        }

        private void axComiDaq1_DigitalInStateChanged(object sender, AxCOMIDAQLib._DComiDaqEvents_DigitalInStateChangedEvent e)
        {

        }

        private void CmbRange_SelectedIndexChanged(object sender, EventArgs e)
        {
            float Vmin = 0, Vmax = 0;
            switch (CmbRange.SelectedIndex)
            {
                case 0:
                    Vmin = -1;
                    Vmax = 1;
                    break;

                case 1:
                    Vmin = -2;
                    Vmax = 2;
                    break;

                case 2:
                    Vmin = -5;
                    Vmax = 5;
                    break;

                case 3:
                    Vmin = -10;
                    Vmax = 10;
                    break;
            }

            for (int ch = 0; ch < CH_NUM; ch++)
            {
                CDDLL.COMI_AD_SetRange(g_hDevice, ch, Vmin, Vmax);
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            CDDLL.COMI_UnloadDevice(g_hDevice);
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            listBox1.Items.Clear();
        }
    }
}
